import { string } from 'alga-js'
import elasticHelper from "../../../utils/elasticHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"

export default defineEventHandler(async (event) => {
  const qry = getRouterParam(event, 'query')

  let data: any = {
    c_bpartner: [],
    m_product: [],
    c_order: [],
    m_inout: [],
    ad_user: [],
    c_invoice: [],
    r_request: []
  }

  try {
    const models: string[] = Object.keys(data)
    for(let model of models) {
      const res: any = await elasticHelper(`${model}/_search?pretty`, 'POST', {
        query: {
          query_string: {
            query: qry
          }
        }
      })
      if(res) {
        data[model] = res
      }
    }
  } catch(error: any) {
    data = errorHandlingHelper(error, error)
  }

  return data
})
